var prefs = { get: "" };
var ru99px = {
  RU99PX_URL: "https://99px.ru/GVBT6oPp7NcMO6qPZ/56/addimage/",
  RU99PX_URL_AVATAR: "https://99px.ru/GVBT6oPp7NcMO6qPZ/1/addimage/",
  RU99PX_URL_VKAVATAR: "https://99px.ru/GVBT6oPp7NcMO6qPZ/41/addimage/",
  RU99PX_URL_WALLPAPER: "https://99px.ru/GVBT6oPp7NcMO6qPZ/53/addimage/",
  RU99PX_URL_MOBILE: "https://99px.ru/GVBT6oPp7NcMO6qPZ/97/addimage/",
  RU99PX_URL_ANIMATION: "https://99px.ru/GVBT6oPp7NcMO6qPZ/86/addimage/",
  RU99PX_QUOTE_URL: "https://99px.ru/cms/mhost.php?tid=57&func=additem",
  RU99PX_MESSAGES_URL:
    "https://99px.ru/cms/mhost.php?tid=17&func=json_export_messages",
  targetURL: "",
  check_new_messages_time: 120000, //Cyclic check posts
  check_new_messages_first_time: 10000, //Initial delay check posts

  createContextMenus: function () {
    chrome.contextMenus.create({
      id: "send_avatar",
      title: "Отправить как аватарку",
      contexts: ["image"],
    });
    chrome.contextMenus.create({
      id: "send_photo",
      title: "Отправить как фото",
      contexts: ["image"],
    });
    chrome.contextMenus.create({
      id: "send_wallpaper",
      title: "Отправить как обои",
      contexts: ["image"],
    });
    chrome.contextMenus.create({
      id: "send_mobile",
      title: "Отправить как обои на телефон",
      contexts: ["image"],
    });
  },

  console: function (tab, ...args) {
    chrome.tabs.sendMessage(tab.id, { action: "console", args: args });
  },

  alert: function (tab, text, timeout) {
    chrome.tabs.sendMessage(tab.id, {
      action: "alert",
      text: text,
      timeout: timeout,
    });
  },

  get_cookie_string: function (url, callback) {
    if (!chrome.cookies) {
      chrome.cookies = chrome.experimental.cookies;
    }

    // An object used for caching data about the browser's cookies, which we update
    // as notifications come in.
    function CookieCache() {
      this.cookies_ = {};

      this.reset = function () {
        this.cookies_ = {};
      };

      this.add = function (cookie) {
        var domain = cookie.domain;
        if (!this.cookies_[domain]) {
          this.cookies_[domain] = [];
        }
        this.cookies_[domain].push(cookie);
      };

      this.remove = function (cookie) {
        var domain = cookie.domain;
        if (this.cookies_[domain]) {
          var i = 0;
          while (i < this.cookies_[domain].length) {
            if (cookieMatch(this.cookies_[domain][i], cookie)) {
              this.cookies_[domain].splice(i, 1);
            } else {
              i++;
            }
          }
          if (this.cookies_[domain].length == 0) {
            delete this.cookies_[domain];
          }
        }
      };

      // Returns a sorted list of cookie domains that match |filter|. If |filter| is
      //  null, returns all domains.
      this.getDomains = function (filter) {
        var result = [];
        sortedKeys(this.cookies_).forEach(function (domain) {
          if (!filter || domain.indexOf(filter) != -1) {
            result.push(domain);
          }
        });
        return result;
      };

      this.getCookies = function (domain) {
        return this.cookies_[domain];
      };
    }

    var cache = new CookieCache();

    chrome.cookies.getAll({}, function (cookies) {
      for (var i in cookies) {
        cache.add(cookies[i]);
      }
      var domain =
        "." +
        url
          .match(/^[\w-]+:\/*\[?([\w\.:-]+)\]?(?::\d+)?/)[1]
          .replace("www.", "");

      var ccs = cache.getCookies(domain);
      var cstring = "";
      for (var i in ccs) {
        cstring += (cstring ? "; " : "") + ccs[i].name + "=" + ccs[i].value;
      }

      if (callback) callback(cstring);
    });

    return "";
  },

  _send: function (info, tab, send_url) {
    if (!info.srcUrl) return;
    if (!/^https?:\/\//.test(tab.url)) {
      ru99px.showAlert(
        tab,
        "Нельзя инjectировать content script в данный тип URL"
      );
      return;
    }

    const ensureContentScript = (cb) => {
      chrome.tabs.sendMessage(
        tab.id,
        { action: "pingContentScript" },
        (response) => {
          if (chrome.runtime.lastError || !response) {
            if (chrome.scripting && chrome.scripting.executeScript) {
              chrome.scripting.executeScript(
                {
                  target: { tabId: tab.id },
                  files: ["content.js"],
                },
                cb
              );
            } else if (chrome.tabs && chrome.tabs.executeScript) {
              chrome.tabs.executeScript(tab.id, { file: "content.js" }, cb);
            } else {
              cb();
            }
          } else {
            cb();
          }
        }
      );
    };

    ensureContentScript(() => {
      chrome.tabs.sendMessage(
        tab.id,
        {
          action: "getImageTitle",
          defaultTitle: tab.title,
        },
        function (response) {
          // Если пользователь закрыл prompt или не ответил, response может быть undefined
          var title = response && response.title ? response.title : tab.title;
          var from = tab.url;

          var params = new URLSearchParams({
            url: info.srcUrl,
            from: from,
            title: title,
          }).toString();

          fetch(send_url, {
            method: "POST",
            headers: {
              "Content-Type": "application/x-www-form-urlencoded",
              "Accept-Charset": "windows-1251",
            },
            credentials: "include",
            body: params,
          })
            .then((resp) => {
              // if (!resp.status.ok) throw new Error("HTTP " + resp.status);
              return resp.json();
            })
            .then((data) => {
              ru99px.console(tab, "99px response:", data);

              //   ru99px.showAlert(tab,"Изображение опубликовано");
              ru99px.handleAjaxResponse(tab, data);
            })
            .catch((err) => {
              ru99px.console(tab, "Fetch error:", err);
              // ru99px.showAlert(tab,"Ошибка сети при отправке данных");
            });
        }
      );
    });
  },

  handleAjaxResponse: function (tab, ret) {
    var pubtext;
    pubtext = ret.moderation ? "Отправлено на модерацию" : "Опубликовано";
    if (ret.status == "ok" && ret.similar) {
      ru99px.showAlert(
        tab,
        "99px.ru",
        pubtext + ", но есть похожие",
        6000,
        ret.edit_href
      );
      return;
    }
    if (ret.status == "ok")
      ru99px.showAlert(tab, "99px.ru", pubtext, 15000, ret.edit_href);
    if (ret.status == "error")
      ru99px.showAlert(tab, "При публикации возникла ошибка: " + ret.text);
    if (ret.status == "unauthorised") {
      ru99px.showAlert(
        tab,
        "Для добавления вам необходимо авторизироваьтся или зарегистрироваться"
      );
      chrome.tabs.create({ url: "https://99px.ru/login/", selected: true });
    }
    if (ret.status == "text_ok")
      ru99px.showAlert(tab, "Цитата опубликована", "", 5000);
    if (ret.status == "text_error")
      ru99px.showAlert(tab, "При публикации возникла ошибка");
  },

  sendPhoto: function (info, tab) {
    ru99px._send(info, tab, ru99px.RU99PX_URL);
  },

  sendAvatar: function (info, tab, se) {
    ru99px._send(info, tab, ru99px.RU99PX_URL_AVATAR);
  },

  sendVkAvatar: function (info, tab) {
    ru99px._send(info, tab, ru99px.RU99PX_URL_VKAVATAR);
  },

  sendWallpaper: function (info, tab) {
    ru99px._send(info, tab, ru99px.RU99PX_URL_WALLPAPER);
  },

  sendMobile: function (info, tab) {
    ru99px._send(info, tab, ru99px.RU99PX_URL_MOBILE);
  },

  sendAnimation: function (info, tab) {
    ru99px._send(info, tab, ru99px.RU99PX_URL_ANIMATION);
  },

  sendQuote: function (info, tab) {
    if (!ru99px.quoteText) return;

    var location =
      ru99px.RU99PX_QUOTE_URL +
      "&text=" +
      encodeURIComponent(ru99px.quoteText) +
      "&from=" +
      encodeURIComponent(tab.url) +
      "&author=" +
      encodeURIComponent(ru99px.quoteAuthor) +
      "&tags=" +
      encodeURIComponent(ru99px.quoteTags);
    ru99px.ajax.get(location, "", ru99px.handleAjaxResponse);
  },

  ajax: {
    //Object with Ajax
    toid: function (url, id, params) {
      //Returns the element with ID
      if (id && document.getElementById(id))
        ru99px.ajax.get(url, params, ru99px.ajax.toid_return, "", { id: id });
    },
    toid_return: function (args) {
      //return function to the element with ID
      if (args.id && document.getElementById(args.id))
        document.getElementById(args.id).innerHTML = args.text;
    },
    get: function (url, params, func, die, args) {
      //Make the request and performs the functions
      var sajaxReqz = new XMLHttpRequest();
      sajaxReqz.onload = function () {
        ru99px.ajax.process(sajaxReqz, func, die, args);
      };
      params = params ? params : "params=get";

      sajaxReqz.open("POST", url, true);
      sajaxReqz.setRequestHeader(
        "Content-Type",
        "application/x-www-form-urlencoded"
      );
      sajaxReqz.setRequestHeader("Accept-Charset", "windows-1251");
      sajaxReqz.setRequestHeader("Content-Length", params.length);
      sajaxReqz.send(params);
    },
    process: function (sajaxReq, func, die, args) {
      //reset function
      if (sajaxReq && sajaxReq.readyState == 4 && sajaxReq.status == 200)
        if (func) {
          if (args != null) {
            args["text"] = sajaxReq.responseText;
          } else {
            args = {
              text: sajaxReq.responseText,
            };
          }
          func(args);
        } else if (die) die(sajaxReq);
    },
  },

  alert_autoclose_time: 5000, //Задержка уведомления
  alert_block: false, //Blocking showing of alerts
  alerts: [], //Set Alert shows the sequence

  showNotification: function (title, text, showTime, clickUrl, onClose) {
    // Используем chrome.notifications для MV3
    showTime = showTime ? showTime : 15000;

    console.log("showNotification:", showTime);
    chrome.notifications.create(
      {
        type: "basic",
        // iconUrl: chrome.runtime.getURL("logo_32x32.png"),
        title: title,
        message: text,
      },
      function (notificationId) {
        if (chrome.runtime.lastError) {
          console.error("Notification error:", chrome.runtime.lastError);
        }
        if (showTime && notificationId) {
          setTimeout(function () {
            chrome.notifications.clear(notificationId);
          }, showTime);
        }
      }
    );
    // clickUrl и onClose можно реализовать через события chrome.notifications.onClicked и onClosed
    if (clickUrl) {
      chrome.notifications.onClicked.addListener(function handler(id) {
        if (id) {
          chrome.notifications.clear(id);
          chrome.tabs.create({ url: clickUrl });
        }
        chrome.notifications.onClicked.removeListener(handler);
      });
    }
    if (onClose) {
      chrome.notifications.onClosed.addListener(function handler(id, byUser) {
        onClose();
        chrome.notifications.onClosed.removeListener(handler);
      });
    }
  },
  showAlert: function (tab, ...args) {
    console.log("showAlert called with arguments:", arguments);

    //Displays the popup window
    if (args.length == 1) {
      var title = "99px.ru";
      var text = args[0];
      var autoclose = ru99px.alert_autoclose_time;
    } else {
      var title = args[0];
      var text = args[1];
      var autoclose = ru99px.alert_autoclose_time;
      var link = args[3];
    }
    if (link)
      ru99px.alert(
        tab,
        "<a target='_blank' href='" +
          link +
          "'><h2>" +
          title +
          "</h2><div>" +
          text +
          "</div></a>",
        autoclose
      );
    else
      ru99px.alert(
        tab,        
          "<h2>" +
          title +
          "</h2><div>" +
          text +
          "</div>",
        autoclose
      );
  },

  handleAlertClose: function () {
    ru99px.alert_block = false;
    setTimeout(function () {
      if (ru99px.alerts.length > 0) {
        var arr = ru99px.alerts.shift();
        if (arr) {
          ru99px.showAlert(
            arr[0],
            arr[1],
            arr[2],
            arr[3],
            arr[4],
            arr[5],
            arr[6],
            arr[7]
          );
        }
      }
    }, 1000);
  },
};

// Инициализация контекстного меню при установке/обновлении
chrome.runtime.onInstalled.addListener(ru99px.createContextMenus);

// Обработка кликов по контекстному меню
chrome.contextMenus.onClicked.addListener(function (info, tab) {
  switch (info.menuItemId) {
    case "send_avatar":
      ru99px.sendAvatar(info, tab);
      break;
    case "send_vkavatar":
      ru99px.sendVkAvatar(info, tab);
      break;
    case "send_photo":
      ru99px.sendPhoto(info, tab);
      break;
    case "send_wallpaper":
      ru99px.sendWallpaper(info, tab);
      break;
    case "send_mobile":
      ru99px.sendMobile(info, tab);
      break;
    case "send_animation":
      ru99px.sendAnimation(info, tab);
      break;
    default:
      break;
  }
});
