function showFloatingMessage(message, timeout = 5000) {
  const box = document.createElement('div');
  box.innerHTML = `
    <style>
      h2 {
        font-size: 18px;
        margin: 0 0 10px;
        color: #fff;
      }
      a, a:hover, a:active, a:visited {
        color: #eee;
        text-decoration: none;
      }
   
    </style>
    ${message}
  `; // Use innerHTML to allow HTML formatting
  Object.assign(box.style, {
    position: 'fixed',
    bottom: '20px',
    right: '20px',
    background: '#333',
    color: '#fff',
    padding: '1rem 2rem',
    borderRadius: '6px',
    boxShadow: '0 2px 6px rgba(0,0,0,0.3)',
    zIndex: 99999,
    fontSize: '14px',
    maxWidth: '300px',
    lineHeight: '1.4',
    opacity: '0',
    fontFamily: 'Arial, sans-serif',
    transition: 'opacity 0.3s ease'
  });

  document.body.appendChild(box);
  requestAnimationFrame(() => {
    box.style.opacity = '1';
  });

  setTimeout(() => {
    box.style.opacity = '0';
    setTimeout(() => box.remove(), 300);
  }, timeout);
}


//showFloatingMessage('Уведомление успешно отправлено');




chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
   
    if (message.action === 'pingContentScript') {
      sendResponse({ ok: true })
      return
    }
    if (message.action === 'getImageTitle') {
      const title = prompt(
        'Введите название изображения:',
        message.defaultTitle || ''
      )
      sendResponse({ title: title })
      return true // async response
    }
    if (message.action === 'console') {
      console.log('bg.js:', ...message.args)      
    }
    if (message.action === 'alert') {
      console.log('alert bg.js:', message)   
      showFloatingMessage(message.text, message.timeout || 5000);      
    }
 
  
})
